using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Diagnostics;

namespace BezpieczneDane
{
   internal class WsparcieIO
   {
      private const int MAX_ROZMIAR = 1024;
      public static int Odczytaj(string aPlik)
      {
         char[] bajty = new char[MAX_ROZMIAR];
         
         //odczyt danych z pliku
         StreamReader sr = new StreamReader(aPlik);
         int przeczytane = sr.Read(bajty, 0, MAX_ROZMIAR);
         sr.Close();

         Debug.Assert(przeczytane >= MAX_ROZMIAR, "Bd podczas odczytu danych");

         //konwersja znakw na bajty
         byte[] dane = new byte[MAX_ROZMIAR];
         for (int i = 0; i < bajty.Length && i < dane.Length; i++)
         {
            dane[i] = (byte)bajty[i];
         }

         //deszyfrowanie danych
         dane = SzyfrDeszyfr(dane);
       
         //odczyt wartoci, na ktr skadaj si bity rozproszone po caej przestrzeni danych
         int wynik = ((dane[0] & 0x01) + (dane[12] & 0x02) + (dane[123] & 0x04) + 
               (dane[111] & 0x08) + (dane[237] & 0x10) + (dane[334] & 0x20) + (dane[18] & 0x40) + 
               (dane[467] & 0x80)) << 8;
         wynik += (dane[511] & 0x01) + (dane[62] & 0x02) + (dane[17] & 0x04) +
               (dane[289] & 0x08) + (dane[455] & 0x10) + (dane[501] & 0x20) + (dane[8] & 0x40) + 
               (dane[427] & 0x80);

         return wynik;
      }

      public static void Zapisz(string aPlik, int aWart)
      {
         byte[] doZapisu = new byte[MAX_ROZMIAR];
         Random rand = new Random();

         //zapisywane dane inicjalizujemy losowymi liczbami
         rand.Nextbajty(doZapisu);

         //warto rozpraszamy po caej przestrzeni danych zapisujc kady bit w innej lokalizacji
         //tylko pojedyncze bity pozostaj niezmienne, reszta danych jest losowa
         doZapisu[511] = (byte)((doZapisu[511] & 0xfe) + (aWart & 0x01));
         aWart >>= 1;
         doZapisu[62] = (byte)((doZapisu[62] & 0xfd) + ((aWart & 0x01) << 1));
         aWart >>= 1;
         doZapisu[17] = (byte)((doZapisu[17] & 0xfb) + ((aWart & 0x01) << 2));
         aWart >>= 1;
         doZapisu[289] = (byte)((doZapisu[289] & 0xf7) + ((aWart & 0x01) << 3));
         aWart >>= 1;
         doZapisu[455] = (byte)((doZapisu[455] & 0xef) + ((aWart & 0x01) << 4));
         aWart >>= 1;
         doZapisu[501] = (byte)((doZapisu[501] & 0xdf) + ((aWart & 0x01) << 5));
         aWart >>= 1;
         doZapisu[8] = (byte)((doZapisu[8] & 0xbf) + ((aWart & 0x01) << 6));
         aWart >>= 1;
         doZapisu[427] = (byte)((doZapisu[427] & 0x7f) + ((aWart & 0x01) << 7));
         aWart >>= 1;
         doZapisu[0] = (byte)((doZapisu[0] & 0xfe) + (aWart & 0x01));
         aWart >>= 1;
         doZapisu[12] = (byte)((doZapisu[12] & 0xfd) + ((aWart & 0x01) << 1));
         aWart >>= 1;
         doZapisu[123] = (byte)((doZapisu[123] & 0xfb) + ((aWart & 0x01) << 2));
         aWart >>= 1;
         doZapisu[111] = (byte)((doZapisu[111] & 0xf7) + ((aWart & 0x01) << 3));
         aWart >>= 1;
         doZapisu[237] = (byte)((doZapisu[237] & 0xef) + ((aWart & 0x01) << 4));
         aWart >>= 1;
         doZapisu[334] = (byte)((doZapisu[334] & 0xdf) + ((aWart & 0x01) << 5));
         aWart >>= 1;
         doZapisu[18] = (byte)((doZapisu[18] & 0xbf) + ((aWart & 0x01) << 6));
         aWart >>= 1;
         doZapisu[467] = (byte)((doZapisu[467] & 0x7f) + ((aWart & 0x01) << 7));
         aWart >>= 1;
         
        
         //wykonujemy szyfrowanie
         doZapisu = SzyfrDeszyfr(doZapisu);
         
         char[] buforZapisu = new char[MAX_ROZMIAR];
         for (int i = 0; i < doZapisu.Length; i++)
         {
            buforZapisu[i] = (char)doZapisu[i];
         }

         StreamWriter sw = new StreamWriter(aPlik, false);
         sw.Write(buforZapisu);
         sw.Close();
      }

      public static byte[] SzyfrDeszyfr(byte[] aDane)
      {
         byte[] klucz = { 0x03, 0xda, 0x87, 0x34, 0x30, 0x0A, 0xaa, 0x76, 0xf9, 0x01, 0x00, 0xEE, 0x18,  0x2a };
         byte[] wartZwrot = RC4.Encrypt(klucz, aDane);
         return wartZwrot;
      }
   }
}
